#include "meson-sample.h"

#include "get-prgname.h"
#include "fake-gthread.h"

struct _MesonSample {
  GObject parent_instance;
};

G_DEFINE_TYPE (MesonSample, meson_sample, G_TYPE_OBJECT)

/**
 * meson_sample_new:
 *
 * Allocates a new #MesonSample.
 *
 * Returns: (transfer full): a #MesonSample.
 */
MesonSample *
meson_sample_new (void)
{
  return g_object_new (MESON_TYPE_SAMPLE, NULL);
}

static void
meson_sample_class_init (MesonSampleClass *klass)
{
}

static void
meson_sample_init (MesonSample *self)
{
}

/**
 * meson_sample_print_message:
 * @self: a #MesonSample.
 *
 * Prints a message.
 */
void
meson_sample_print_message (MesonSample *self)
{
  g_return_if_fail (MESON_IS_SAMPLE (self));

  g_print ("Message: %s\n", get_prgname_get_name ());
  g_print ("Message: %d\n", fake_gthread_fake_function ());
}
